<?php
/**
 * Unblock Phone Number
 * این فایل برای باز کردن قفل شماره‌های مسدود شده است
 * Run and then DELETE this file!
 */

require_once __DIR__ . '/config/config.php';

$message = '';
$messageType = '';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['phone'])) {
    $phone = sanitize($_POST['phone']);
    $phone = convertPersianToEnglish($phone);
    
    if (validateMobile($phone)) {
        $conn = getDBConnection();
        
        // Delete all blocks for this phone
        $stmt = $conn->prepare("DELETE FROM otp_rate_limits WHERE phone = ?");
        $stmt->bind_param("s", $phone);
        $stmt->execute();
        $deletedCount = $stmt->affected_rows;
        $stmt->close();
        $conn->close();
        
        if ($deletedCount > 0) {
            $message = "✅ شماره {$phone} با موفقیت از لیست مسدودی خارج شد! ({$deletedCount} رکورد حذف شد)";
            $messageType = 'success';
        } else {
            $message = "ℹ️ این شماره قبلاً مسدود نبود: {$phone}";
            $messageType = 'info';
        }
    } else {
        $message = "❌ شماره موبایل نامعتبر است!";
        $messageType = 'error';
    }
}

// Handle unblock all
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['unblock_all'])) {
    $conn = getDBConnection();
    
    // Delete all expired blocks
    $result = $conn->query("DELETE FROM otp_rate_limits WHERE blocked_until < NOW()");
    $deletedCount = $conn->affected_rows;
    
    $conn->close();
    
    if ($deletedCount > 0) {
        $message = "✅ تمام مسدودی‌های منقضی شده پاک شدند! ({$deletedCount} رکورد)";
        $messageType = 'success';
    } else {
        $message = "ℹ️ هیچ مسدودی منقضی شده‌ای وجود نداشت";
        $messageType = 'info';
    }
}

// Get currently blocked phones
$conn = getDBConnection();
$result = $conn->query("SELECT phone, ip_address, action, attempts, blocked_until, created_at 
                        FROM otp_rate_limits 
                        WHERE blocked_until > NOW() 
                        ORDER BY blocked_until DESC");
$blockedPhones = $result->fetch_all(MYSQLI_ASSOC);
$conn->close();
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>باز کردن قفل شماره‌ها</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Tahoma', Arial, sans-serif;
            direction: rtl;
            text-align: right;
            padding: 20px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        
        .container {
            max-width: 900px;
            margin: 0 auto;
            background: white;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2);
        }
        
        h1 {
            color: #333;
            margin-bottom: 10px;
            font-size: 28px;
        }
        
        .subtitle {
            color: #666;
            margin-bottom: 30px;
            font-size: 14px;
        }
        
        .warning {
            background: #fff3cd;
            border: 2px solid #ffc107;
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 30px;
            color: #856404;
        }
        
        .warning strong {
            color: #d32f2f;
        }
        
        .form-section {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 30px;
        }
        
        .form-section h2 {
            color: #667eea;
            margin-bottom: 15px;
            font-size: 20px;
        }
        
        .form-group {
            margin-bottom: 15px;
        }
        
        label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: bold;
        }
        
        input[type="text"] {
            width: 100%;
            padding: 12px;
            border: 2px solid #ddd;
            border-radius: 8px;
            font-size: 16px;
            text-align: center;
            font-family: 'Tahoma', Arial;
            direction: ltr;
            letter-spacing: 2px;
        }
        
        input[type="text"]:focus {
            outline: none;
            border-color: #667eea;
        }
        
        .btn {
            padding: 12px 30px;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            font-family: 'Tahoma', Arial;
            transition: all 0.3s;
        }
        
        .btn-primary {
            background: #667eea;
            color: white;
        }
        
        .btn-primary:hover {
            background: #5568d3;
            transform: translateY(-2px);
        }
        
        .btn-danger {
            background: #f44336;
            color: white;
        }
        
        .btn-danger:hover {
            background: #da190b;
        }
        
        .btn-block {
            width: 100%;
        }
        
        .message {
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 20px;
            font-weight: bold;
        }
        
        .message.success {
            background: #d4edda;
            color: #155724;
            border: 2px solid #c3e6cb;
        }
        
        .message.error {
            background: #f8d7da;
            color: #721c24;
            border: 2px solid #f5c6cb;
        }
        
        .message.info {
            background: #d1ecf1;
            color: #0c5460;
            border: 2px solid #bee5eb;
        }
        
        .blocked-list {
            margin-top: 30px;
        }
        
        .blocked-list h2 {
            color: #333;
            margin-bottom: 20px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            background: white;
        }
        
        th {
            background: #667eea;
            color: white;
            padding: 12px;
            text-align: right;
            font-weight: bold;
        }
        
        td {
            padding: 12px;
            border-bottom: 1px solid #ddd;
        }
        
        tr:hover {
            background: #f8f9fa;
        }
        
        .no-data {
            text-align: center;
            padding: 40px;
            color: #999;
            font-size: 16px;
        }
        
        .badge {
            display: inline-block;
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: bold;
        }
        
        .badge-send {
            background: #fff3cd;
            color: #856404;
        }
        
        .badge-verify {
            background: #d1ecf1;
            color: #0c5460;
        }
        
        .time-remaining {
            color: #f44336;
            font-weight: bold;
        }
        
        hr {
            margin: 30px 0;
            border: none;
            border-top: 2px solid #e0e0e0;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔓 باز کردن قفل شماره‌ها</h1>
        <p class="subtitle">مدیریت شماره‌های مسدود شده در سیستم OTP</p>
        
        <div class="warning">
            <strong>⚠️ هشدار امنیتی:</strong>
            این صفحه برای مدیران است! بعد از استفاده <strong>حتماً این فایل را حذف کنید</strong>: <code>unblock-phone.php</code>
        </div>
        
        <?php if ($message): ?>
            <div class="message <?php echo $messageType; ?>">
                <?php echo $message; ?>
            </div>
        <?php endif; ?>
        
        <!-- Unblock Single Phone -->
        <div class="form-section">
            <h2>📱 باز کردن قفل یک شماره</h2>
            <form method="POST">
                <div class="form-group">
                    <label>شماره موبایل:</label>
                    <input type="text" name="phone" placeholder="09123456789" required>
                </div>
                <button type="submit" class="btn btn-primary btn-block">
                    🔓 باز کردن قفل این شماره
                </button>
            </form>
        </div>
        
        <hr>
        
        <!-- Unblock All Expired -->
        <div class="form-section">
            <h2>🧹 پاک کردن مسدودی‌های منقضی شده</h2>
            <p style="margin-bottom: 15px; color: #666;">
                مسدودی‌هایی که زمانشان گذشته اما هنوز در دیتابیس هستند را پاک می‌کند.
            </p>
            <form method="POST">
                <button type="submit" name="unblock_all" class="btn btn-danger btn-block">
                    🗑️ پاک کردن تمام مسدودی‌های منقضی شده
                </button>
            </form>
        </div>
        
        <!-- List of Blocked Phones -->
        <div class="blocked-list">
            <h2>📋 لیست شماره‌های مسدود شده (<?php echo count($blockedPhones); ?>)</h2>
            
            <?php if (empty($blockedPhones)): ?>
                <div class="no-data">
                    ✅ هیچ شماره‌ای در حال حاضر مسدود نیست!
                </div>
            <?php else: ?>
                <table>
                    <thead>
                        <tr>
                            <th>شماره موبایل</th>
                            <th>نوع عملیات</th>
                            <th>تعداد تلاش</th>
                            <th>مسدود تا</th>
                            <th>زمان باقی‌مانده</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($blockedPhones as $blocked): ?>
                            <?php
                                $blockedUntil = strtotime($blocked['blocked_until']);
                                $now = time();
                                $remaining = $blockedUntil - $now;
                                $remainingMinutes = ceil($remaining / 60);
                            ?>
                            <tr>
                                <td style="direction: ltr; text-align: right; font-weight: bold;">
                                    <?php echo htmlspecialchars($blocked['phone']); ?>
                                </td>
                                <td>
                                    <span class="badge badge-<?php echo $blocked['action']; ?>">
                                        <?php echo $blocked['action'] === 'send' ? 'ارسال' : 'تایید'; ?>
                                    </span>
                                </td>
                                <td><?php echo $blocked['attempts']; ?> تلاش</td>
                                <td><?php echo date('H:i:s', $blockedUntil); ?></td>
                                <td class="time-remaining">
                                    <?php echo $remainingMinutes; ?> دقیقه
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
        
        <hr>
        
        <p style="text-align: center; color: #999; font-size: 14px;">
            <strong style="color: #f44336;">⚠️ یادت نره:</strong> 
            بعد از استفاده این فایل را حذف کن: <code>unblock-phone.php</code>
        </p>
    </div>
    
    <script>
        // Auto refresh every 30 seconds to update remaining time
        setTimeout(function() {
            location.reload();
        }, 30000);
    </script>
</body>
</html>

